@rem = '--*-Perl-*--
@echo off
if "%OS%" == "Windows_NT" goto WinNT
perl -x -S "%0" %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
:WinNT
perl -x -S %0 %*
if NOT "%COMSPEC%" == "%SystemRoot%\system32\cmd.exe" goto endofperl
if %errorlevel% == 9009 echo You do not have Perl in your PATH.
if errorlevel 1 goto script_failed_so_exit_with_non_zero_val 2>nul
goto endofperl
@rem ';
#! /c/Perl/bin//perl -w
#line 15
# -*- Perl -*-
#
# nmzgrep - search namazu-indexed documents for a given pattern and 
#           print lines matching the pattern.
# 
# $Id: nmzgrep.in,v 1.1.8.2 2004/09/19 03:37:44 opengl2772 Exp $
#
# Copyright (C) 1999 Satoru Takabayashi  All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either versions 2, or (at your option)
#  any later version.
# 
#  This program is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
#  02111-1307, USA
#

use strict;
use FileHandle;

if (@ARGV == 0) {
    print "usage: nmzgrep [egrep's options] <pattern> [index]...\n";
    exit 1;
}

my @opts = ();
while (defined $ARGV[0] && $ARGV[0] =~ /^-/) {
    push @opts, $ARGV[0];
    shift @ARGV;
}

if (@ARGV == 0) {
    print "usage: nmzgrep [egrep's options] <pattern> [index]...\n";
    exit 1;
}

my $pattern = shift @ARGV;
my @indices = @ARGV;
my $command = "namazu -alR $pattern @indices |\
               xargs egrep @opts $pattern /dev/null";

my $fh = new FileHandle;
$fh->open("$command |");
if (defined $fh) {
    while (<$fh>) {
	print;
    }
} else {
    die "nmzgrep: $!";
}

exit 0;

__END__
:endofperl
